[Setup]
;-- Main Setup Information
 AppName                  = SQL-Exchange Server
 AppVerName               = SQL-Exchange Server 1.0.0.0
 AppCopyright             = Copyright  1995-2003 Enginuity.
 DefaultDirName           = {pf}\Enginuity\SQL-Exchange
 DefaultGroupName         = Enginuity\SQL-Exchange
 UninstallDisplayIcon     = {app}\SQLEServer.Exe
 UninstallStyle           = Modern
 WizardImageFile          = Resources\LgSetup.bmp
 WizardSmallImageFile     = Resources\SmSetup.bmp
 PrivilegesRequired       = PowerUser
 Uninstallable            = Yes
 AppMutex                 = SQL-Exchange Server
 LicenseFile              = Resources\EULA.txt
 Compression              = ZIP/9
 OutputBaseFilename       = Setup
;UninstallLogMode         = OverWrite
 UninstallRestartComputer = Yes
 DirExistsWarning         = No

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = Enginuity
 AppPublisherURL = http://www.MyEnginuity.com/
 AppUpdatesURL   = http://www.MyEnginuity.com/
 AppVersion      = 1.0.0.0

[Files]
 Source: "..\Debug\SQLEServer.Exe";           DestDir: "{app}"; Flags: IgnoreVersion RestartReplace;
 Source: "ServiceCtl\Release\ServiceCtl.Exe"; DestDir: "{app}"; Flags: IgnoreVersion;

 Source: "Resources\EULA.txt";                DestDir: "{app}"; Flags: IgnoreVersion;

 Source: "Libraries\NSWFL.Dll";               DestDir: "{app}"; Flags: RestartReplace;
 Source: "Libraries\NASCCL.Dll";              DestDir: "{app}"; Flags: RestartReplace;

[Icons]
 Name: "{group}\SQL-Exchange Server";       Filename: "{app}\SQL-Exchange Server.EXE"; WorkingDir: "{app}";

[Dirs]
 Name: "{app}\Logs"

[Registry]
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "Path";              ValueType: String; ValueData: "{app}";           Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "SessionLogDir";     ValueType: String; ValueData: "{app}\Logs";      Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "SQLIndexDatabase";  ValueType: String; ValueData: "WebPortalIndex";  Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "SQLIndexDriver";    ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "SQLIndexPassword";  ValueType: String; ValueData: "SQL840823110";    Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "SQLIndexServer";    ValueType: String; ValueData: "NetBase";         Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "SQLIndexUserID";    ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "ListenPort";        ValueType: Dword;  ValueData: "6632";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "MaxConnections";    ValueType: Dword;  ValueData: "10";              Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Enginuity\SQL-Exchange\Server"; ValueName: "TCPLoopDelay";      ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;

[Run]
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/install";
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/start";

[UninstallRun]
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/delete"; RunOnceId: "DeleteService"; MinVersion: 0, 4.0

